<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwvars wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterProjectSplitsType" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterStylesType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterTOCDataType" />
 <xsl:param name="ParameterAllowBaggage" />
 <xsl:param name="ParameterAllowGroupToGroup" />
 <xsl:param name="ParameterAllowURL" />
 <xsl:param name="ParameterBaggageSplitFileType" />
 <xsl:param name="ParameterTOCSplitFileType" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterDocumentPDFType" />
 <xsl:param name="ParameterGroupPDFType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:variable name="GlobalDefaultNamespace" select="'http://www.w3.org/1999/xhtml'" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />
 <xsl:preserve-space elements="html:script" />


 <xsl:include href="wwtransform:common/accessibility/images.xsl"/>
 <xsl:include href="wwtransform:common/accessibility/tables.xsl"/>
 <xsl:include href="wwtransform:common/behaviors/options.xsl"/>
 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:common/links/resolve.xsl" />
 <xsl:include href="wwtransform:common/pages/pages.xsl" />
 <xsl:include href="wwtransform:common/project/conditions.xsl" />
 <xsl:include href="wwtransform:common/project/properties.xsl" />
 <xsl:include href="wwtransform:common/tables/tables.xsl" />
 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />
 <xsl:include href="wwformat:Transforms/wwhelp_context.xsl" />
 <xsl:include href="wwformat:Transforms/content.xsl" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/accessibility/images.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/accessibility/images.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/accessibility/tables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/accessibility/tables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/behaviors/options.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/behaviors/options.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/links/resolve.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/links/resolve.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pages.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pages.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/project/conditions.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/project/conditions.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/project/properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/project/properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/tables/tables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/tables/tables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/wwhelp_context.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/wwhelp_context.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/content.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Project Splits -->
 <!--                -->
 <xsl:variable name="GlobalProjectSplitsPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectSplitsType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectSplits" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectSplitsPath)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <xsl:call-template name="DocumentsPages">
    <xsl:with-param name="ParamInput" select="$GlobalInput" />
    <xsl:with-param name="ParamProject" select="$GlobalProject" />
    <xsl:with-param name="ParamFiles" select="$GlobalFiles" />
    <xsl:with-param name="ParamLinksType" select="$ParameterLinksType" />
    <xsl:with-param name="ParamDependsType" select="$ParameterDependsType" />
    <xsl:with-param name="ParamSplitsType" select="$ParameterSplitsType" />
    <xsl:with-param name="ParamBehaviorsType" select="$ParameterBehaviorsType" />
    <xsl:with-param name="ParamTOCDataType" select="$ParameterTOCDataType" />
   </xsl:call-template>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Page">
  <xsl:param name="ParamFilesSplits" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamBehaviorsFile" />
  <xsl:param name="ParamBehaviors" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />
  <xsl:param name="ParamFilesDocumentNode" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamContent" />

  <!-- Output -->
  <!--        -->
  <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($ParamSplit/@path, $GlobalProject/wwproject:Project/@ChangeID, $ParamSplit/@groupID, $ParamSplit/@documentID, $GlobalActionChecksum)" />
  <xsl:if test="not($VarUpToDate)">
   <xsl:variable name="VarResultAsXML">
    <!-- Output directory path -->
    <!--                       -->
    <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($ParamSplit/@groupID))" />

    <!-- Page Rule -->
    <!--           -->
    <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', $ParamSplit/@stylename)" />

    <!-- Behaviors for this split -->
    <!--                          -->
    <xsl:variable name="VarSplitBehaviors" select="$ParamBehaviors/wwbehaviors:Behaviors/wwbehaviors:Split[@id = $ParamSplit/@id]" />

    <!-- Keywords Markers -->
    <!--                  -->
    <xsl:variable name="VarKeywordsMarkers" select="$VarSplitBehaviors//wwbehaviors:Marker[@behavior = 'keywords']" />

    <!-- Split files -->
    <!--             -->
    <xsl:for-each select="$ParamSplits[1]">
     <!-- TOC -->
     <!--     -->
     <xsl:variable name="VarTOCSplitFile" select="key('wwsplits-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterTOCSplitFileType))[1]" />

     <!-- Index -->
     <!--       -->
     <xsl:variable name="VarIndexSplitFile" select="key('wwsplits-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

     <!-- Previous -->
     <!--          -->
     <xsl:variable name="VarPossiblePreviousSplits" select="$ParamSplit/preceding-sibling::wwsplits:Split[1]" />
     <xsl:variable name="VarPreviousSplit" select="($VarPossiblePreviousSplits[count($VarPossiblePreviousSplits) = 1] | $VarTOCSplitFile[(count($VarPossiblePreviousSplits) = 0) and (count($ParamSplit | $VarTOCSplitFile) = 2)])" />

     <!-- Next -->
     <!--      -->
     <xsl:variable name="VarPossibleNextSplits" select="$ParamSplit/following-sibling::wwsplits:Split[1]" />
     <xsl:variable name="VarNextSplit" select="($VarPossibleNextSplits[count($VarPossibleNextSplits) = 1] | $VarIndexSplitFile[(count($VarPossibleNextSplits) = 0) and (count($ParamSplit | $VarIndexSplitFile) = 2)])" />

     <!-- Skip Navigation Link -->
     <!--                      -->
     <xsl:variable name="VarSkipNavigationURI">
      <xsl:if test="wwprojext:GetFormatSetting('accessibility-skip-navigation-link', 'false') = 'true'">
       <xsl:text>#</xsl:text>
       <xsl:value-of select="$ParamSplit/@id" />
      </xsl:if>
     </xsl:variable>

     <!-- PDF Link -->
     <!--          -->
     <xsl:variable name="VarPDFLinkPath">
      <xsl:variable name="VarDocumentPDFPath">
       <xsl:if test="wwprojext:GetFormatSetting('pdf-per-document') = 'true'">
        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:variable name="VarDocumentPDFFile" select="key('wwfiles-files-by-documentid', $ParamFilesDocumentNode/@documentID)[@type = $ParameterDocumentPDFType]" />

         <xsl:for-each select="$VarDocumentPDFFile[1]">
          <xsl:value-of select="@path" />
         </xsl:for-each>
        </xsl:for-each>
       </xsl:if>
      </xsl:variable>

      <xsl:variable name="VarGroupPDFPath">
       <xsl:if test="wwprojext:GetFormatSetting('pdf-per-group') = 'true'">
        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:variable name="VarGroupPDFFile" select="key('wwfiles-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterGroupPDFType))" />

         <xsl:for-each select="$VarGroupPDFFile[1]">
          <xsl:value-of select="@path" />
         </xsl:for-each>
        </xsl:for-each>
       </xsl:if>
      </xsl:variable>

      <xsl:choose>
       <xsl:when test="string-length($VarDocumentPDFPath) &gt; 0">
        <xsl:value-of select="$VarDocumentPDFPath" />
       </xsl:when>

       <xsl:when test="string-length($VarGroupPDFPath) &gt; 0">
        <xsl:value-of select="$VarGroupPDFPath" />
       </xsl:when>
      </xsl:choose>
     </xsl:variable>
     <xsl:variable name="VarPDFLinkURI">
      <xsl:if test="string-length($VarPDFLinkPath) &gt; 0">
       <xsl:value-of select="wwuri:GetRelativeTo($VarPDFLinkPath, $ParamSplit/@path)" />
      </xsl:if>
     </xsl:variable>

     <!-- Notes -->
     <!--       -->
     <xsl:variable name="VarNotes" select="$ParamContent//wwdoc:Note[not(ancestor::wwdoc:Table) and not(ancestor::wwdoc:Frame)]" />

     <!-- Note numbering -->
     <!--                -->
     <xsl:variable name="VarNoteNumberingAsXML">
      <xsl:call-template name="Notes-Number">
       <xsl:with-param name="ParamNotes" select="$VarNotes" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarNoteNumbering" select="msxsl:node-set($VarNoteNumberingAsXML)" />

     <!-- Cargo -->
     <!--       -->
     <xsl:variable name="VarCargo" select="$ParamBehaviors | $VarNoteNumbering" />

     <!-- Conditions -->
     <!--            -->
     <xsl:variable name="VarInitialConditionsAsXML">
      <!-- catalog-css -->
      <!--             -->
      <wwpage:Condition name="catalog-css" />

      <!-- document-css -->
      <!--              -->
      <xsl:if test="string-length($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value) &gt; 0">
       <wwpage:Condition name="document-css" />
      </xsl:if>

      <!-- skip-navigation -->
      <!--                 -->
      <xsl:if test="string-length($VarSkipNavigationURI) &gt; 0">
       <wwpage:Condition name="skip-navigation" />
      </xsl:if>

      <!-- wwhelp-pdf-link-exists -->
      <!--                        -->
      <xsl:if test="string-length($VarPDFLinkURI) &gt; 0">
       <wwpage:Condition name="wwhelp-pdf-link-exists" />
      </xsl:if>

      <!-- breadcrumbs-top -->
      <!--                 -->
      <xsl:variable name="VarBreadcrumbsTopGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'breadcrumbs-top-generate']/@Value" />
      <xsl:if test="($VarBreadcrumbsTopGenerateOption = 'true') or (string-length($VarBreadcrumbsTopGenerateOption) = 0)">
       <wwpage:Condition name="breadcrumbs-top" />
      </xsl:if>

      <!-- breadcrumbs-bottom -->
      <!--                    -->
      <xsl:variable name="VarBreadcrumbsBottomGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'breadcrumbs-bottom-generate']/@Value" />
      <xsl:if test="$VarBreadcrumbsBottomGenerateOption = 'true'">
       <wwpage:Condition name="breadcrumbs-bottom" />
      </xsl:if>

      <!-- Keywords? -->
      <!--           -->
      <xsl:if test="count($VarKeywordsMarkers[1]) = 1">
       <wwpage:Condition name="keywords-exist" />
      </xsl:if>

      <!-- Company Info -->
      <!--              -->
      <xsl:call-template name="CompanyInfo-Conditions">
       <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarInitialConditions" select="msxsl:node-set($VarInitialConditionsAsXML)" />

     <!-- Set header/footer conditions -->
     <!--                              -->
     <xsl:variable name="VarConditionsAsXML">
      <!-- Copy existing as is -->
      <!--                     -->
      <xsl:for-each select="$VarInitialConditions/*">
       <xsl:copy-of select="." />
      </xsl:for-each>

      <xsl:for-each select="$VarInitialConditions[1]">
       <!-- header-exists -->
       <!--               -->
       <xsl:variable name="VarHeaderExists" select="count(key('wwpage-conditions-by-name', 'breadcrumbs-top') | key('wwpage-conditions-by-name', 'company-info-top')) &gt; 0" />
       <xsl:if test="$VarHeaderExists">
        <wwpage:Condition name="header-exists" />
       </xsl:if>

       <!-- footer-exists -->
       <!--               -->
       <xsl:variable name="VarFooterExists" select="count(key('wwpage-conditions-by-name', 'breadcrumbs-bottom') | key('wwpage-conditions-by-name', 'company-info-bottom')) &gt; 0" />
       <xsl:if test="$VarFooterExists">
        <wwpage:Condition name="footer-exists" />
       </xsl:if>

       <!-- header-footer-exists -->
       <!--                      -->
       <xsl:choose>
        <xsl:when test="$VarHeaderExists or $VarFooterExists">
         <wwpage:Condition name="header-footer-exists" />
        </xsl:when>

        <xsl:otherwise>
         <wwpage:Condition name="header-footer-not-exists" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

     <!-- Replacements -->
     <!--              -->
     <xsl:variable name="VarReplacementsAsXML">
      <xsl:variable name="VarRelativeRootURIWithDummyComponent" select="wwuri:GetRelativeTo(wwfilesystem:Combine($VarOutputDirectoryPath, 'dummy.component'), $ParamSplit/@path)" />
      <xsl:variable name="VarRelativeRootURI">
       <xsl:variable name="VarStringLengthDifference" select="string-length($VarRelativeRootURIWithDummyComponent) - string-length('dummy.component')" />
       <xsl:choose>
        <xsl:when test="$VarStringLengthDifference &lt;= 0">
         <xsl:value-of select="''" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="substring($VarRelativeRootURIWithDummyComponent, 1, $VarStringLengthDifference)" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- webworks-root -->
      <!--               -->
      <wwpage:Replacement name="webworks-root">
       <xsl:comment>
        <xsl:text>
</xsl:text>
        <xsl:text>        var  WebWorksRootPath = &quot;</xsl:text>
        <xsl:value-of select="$VarRelativeRootURI" />
        <xsl:text>&quot;;
</xsl:text>
        <xsl:text>      // </xsl:text>
       </xsl:comment>
      </wwpage:Replacement>

      <!-- wwhelp-frame -->
      <!--              -->
      <wwpage:Replacement name="wwhelp-frame">
       <xsl:comment>
        <xsl:text>
</xsl:text>
        <xsl:text>        // Set reference to top level help frame
</xsl:text>
        <xsl:text>        //
</xsl:text>
        <xsl:text>        var  WWHFrame = WWHGetWWHFrame(&quot;</xsl:text>
        <xsl:value-of select="$VarRelativeRootURI" />
        <xsl:text>&quot;, true);
</xsl:text>
        <xsl:text>      // </xsl:text>
       </xsl:comment>
      </wwpage:Replacement>

      <!-- wwhelp-pdf-link -->
      <!--                 -->
      <wwpage:Replacement name="wwhelp-pdf-link">
       <html:script type="text/javascript" language="JavaScript1.2">
        <xsl:comment>
         <xsl:text>
</xsl:text>
         <xsl:text>        function  WWHPDFLink()
</xsl:text>
         <xsl:text>        {
</xsl:text>
         <xsl:text>          return &quot;</xsl:text>
         <xsl:value-of select="$VarPDFLinkURI" />
         <xsl:text>&quot;;
</xsl:text>
         <xsl:text>        }
</xsl:text>
         <xsl:text>      // </xsl:text>
        </xsl:comment>
       </html:script>
      </wwpage:Replacement>

      <!-- body-class -->
      <!--            -->
      <wwpage:Replacement name="body-class">
       <xsl:attribute name="value">
        <!-- Additional CSS classes -->
        <!--                        -->
        <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
        <xsl:value-of select="$VarAdditionalCSSClassesOption" />
       </xsl:attribute>
      </wwpage:Replacement>

      <!-- body-style -->
      <!--            -->
      <wwpage:Replacement name="body-style">
       <xsl:attribute name="value">
        <!-- CSS properties -->
        <!--                -->
        <xsl:variable name="VarCSSPropertiesAsXML">
         <xsl:call-template name="CSS-TranslateProjectProperties">
          <xsl:with-param name="ParamProperties" select="$VarPageRule/wwproject:Properties/wwproject:Property" />
          <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
          <xsl:with-param name="ParamSplits" select="$ParamSplits" />
         </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

        <xsl:call-template name="CSS-InlineProperties">
         <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
        </xsl:call-template>
       </xsl:attribute>
      </wwpage:Replacement>

      <wwpage:Replacement name="title" value="{$ParamSplit/@title}" />
      <wwpage:Replacement name="navigation-toc-title" value="{$VarTOCSplitFile/@title}" />

      <wwpage:Replacement name="catalog-css">
       <xsl:attribute name="value">
        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:variable name="VarCSSPath" select="key('wwfiles-files-by-documentid', $ParamFilesDocumentNode/@documentID)[@type = $ParameterStylesType]/@path" />
         <xsl:value-of select="wwuri:GetRelativeTo($VarCSSPath, $ParamSplit/@path)" />
        </xsl:for-each>
       </xsl:attribute>
      </wwpage:Replacement>

      <wwpage:Replacement name="document-css">
       <xsl:attribute name="value">
        <xsl:call-template name="URI-ResolveProjectFileURI">
         <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
         <xsl:with-param name="ParamSplits" select="$ParamSplits" />
         <xsl:with-param name="ParamURI" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value" />
        </xsl:call-template>
       </xsl:attribute>
      </wwpage:Replacement>

      <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
      <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

      <wwpage:Replacement name="breadcrumbs-top-style">
       <xsl:attribute name="value">
        <xsl:variable name="VarAlignmentProperty" select="$VarPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-top-alignment']/@Value" />
        <xsl:choose>
         <xsl:when test="string-length($VarAlignmentProperty) &gt; 0">
          <xsl:value-of select="concat('text-align: ', $VarAlignmentProperty, ';')" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="'text-align: left;'" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:attribute>
      </wwpage:Replacement>

      <wwpage:Replacement name="breadcrumbs-bottom-style">
       <xsl:attribute name="value">
        <xsl:variable name="VarAlignmentProperty" select="$VarPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-bottom-alignment']/@Value" />
        <xsl:choose>
         <xsl:when test="string-length($VarAlignmentProperty) &gt; 0">
          <xsl:value-of select="concat('text-align: ', $VarAlignmentProperty, ';')" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="'text-align: left;'" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:attribute>
      </wwpage:Replacement>

      <!-- Keywords -->
      <!--          -->
      <xsl:if test="count($VarKeywordsMarkers[1]) = 1">
       <xsl:variable name="VarKeywordText">
        <xsl:for-each select="$VarKeywordsMarkers">
         <xsl:variable name="VarKeywordMarker" select="." />

         <xsl:for-each select="$VarKeywordMarker//wwdoc:Text">
          <xsl:value-of select="@value" />
         </xsl:for-each>
         <xsl:if test="position() != last()">
          <xsl:value-of select="','" />
         </xsl:if>
        </xsl:for-each>
       </xsl:variable>

       <wwpage:Replacement name="meta-keywords" value="{$VarKeywordText}" />
      </xsl:if>

      <!-- Company Info -->
      <!--              -->
      <xsl:call-template name="CompanyInfo-Replacements">
       <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
       <xsl:with-param name="ParamPagePath" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      </xsl:call-template>

      <!-- Breadcrumbs -->
      <!--             -->
      <wwpage:Replacement name="breadcrumbs">
       <xsl:call-template name="Breadcrumbs">
        <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamBreadcrumbTOCEntry" select="$ParamBreadcrumbTOCEntry" />
       </xsl:call-template>
      </wwpage:Replacement>

      <!-- Content -->
      <!--         -->
      <wwpage:Replacement name="content">
       <xsl:call-template name="Content-Content">
        <xsl:with-param name="ParamContent" select="$ParamContent" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$VarCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       </xsl:call-template>
       <xsl:call-template name="Content-Notes">
        <xsl:with-param name="ParamNotes" select="$VarNotes" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$VarCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       </xsl:call-template>
      </wwpage:Replacement>

      <!-- Variables -->
      <!--           -->
      <xsl:variable name="VarSplitGlobalVariablesAsXML">
       <xsl:call-template name="Variables-Globals-Split">
        <xsl:with-param name="ParamProjectVariables" select="$GlobalProjectVariables" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarSplitGlobalVariables" select="msxsl:node-set($VarSplitGlobalVariablesAsXML)/wwvars:Variable" />
      <xsl:call-template name="Variables-Page-String-Replacements">
       <xsl:with-param name="ParamVariables" select="$VarSplitGlobalVariables" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

     <!-- Map common characters -->
     <!--                       -->
     <wwexsldoc:MappingContext>
      <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

      <!-- Invoke page template -->
      <!--                      -->
      <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
       <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
       <xsl:with-param name="ParamOutputPath" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamConditions" select="$VarConditions" />
       <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
      </xsl:apply-templates>
     </wwexsldoc:MappingContext>
    </xsl:for-each>
   </xsl:variable>

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
    <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $ParamSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xhtml', '1.0', 'yes', 'no', 'no', '-//W3C//DTD XHTML 1.0 Transitional//EN', 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd')" />
   </xsl:if>
  </xsl:if>

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <!-- Record files -->
   <!--              -->
   <wwfiles:File path="{$ParamSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($ParamSplit/@path)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$ParamSplit/@groupID}" documentID="{$ParamSplit/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$ParamFilesDocumentNode/@path}" checksum="{$ParamFilesDocumentNode/@checksum}" groupID="{$ParamFilesDocumentNode/@groupID}" documentID="{$ParamFilesDocumentNode/@documentID}" />
    <wwfiles:Depends path="{$ParamFilesSplits/@path}" checksum="{$ParamFilesSplits/@checksum}" groupID="{$ParamFilesSplits/@groupID}" documentID="{$ParamFilesSplits/@documentID}" />
    <wwfiles:Depends path="{$ParamBehaviorsFile/@path}" checksum="{$ParamBehaviorsFile/@checksum}" groupID="{$ParamBehaviorsFile/@groupID}" documentID="{$ParamBehaviorsFile/@documentID}" />
   </wwfiles:File>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
